/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.indexer;

import com.lifelines.dsl.crawler.Tables;
import com.lifelines.indexer.Worker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jooq.Cursor;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.transaction.annotation.Transactional;

@SpringBootApplication
public class IndexerApplication {
    @Value(value="${worker.reindex:false}")
    private boolean workerReindex;

    public static void main(String[] args) {
        ConfigurableApplicationContext context = SpringApplication.run(IndexerApplication.class, (String[])args);
        IndexerApplication application = (IndexerApplication)context.getBean(IndexerApplication.class);
    }

    @Transactional
    public void reindex(ConfigurableApplicationContext context) {
        if (!this.workerReindex) {
            return;
        }
        DSLContext dsl = (DSLContext)context.getBean(DSLContext.class);
        Worker worker = (Worker)context.getBean(Worker.class);
        ResultQuery query = dsl.select((SelectField)Tables.ARTICLES_ARTICLE.ID, (SelectField)Tables.ARTICLES_ARTICLE.CONTENT, (SelectField)Tables.ARTICLES_ARTICLE.TITLE, (SelectField)Tables.ARTICLES_ARTICLE.URL).select(new SelectFieldOrAsterisk[]{Tables.ARTICLES_ARTICLE.PUBDATE, Tables.ARTICLES_ARTICLE.TIMESTAMP, Tables.ARTICLES_ARTICLE.COVER, Tables.ARTICLES_ARTICLE.CHANNEL_ID}).from((TableLike)Tables.ARTICLES_ARTICLE).orderBy((OrderField)Tables.ARTICLES_ARTICLE.TIMESTAMP).fetchSize(250);
        AtomicInteger total = new AtomicInteger();
        try (Cursor cursor = query.fetchLazy();){
            ArrayList batch = new ArrayList();
            while (cursor.hasNext()) {
                Record record = cursor.fetchNext();
                if (record.get((Field)Tables.ARTICLES_ARTICLE.CONTENT) == null) continue;
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("id", record.get((Field)Tables.ARTICLES_ARTICLE.ID));
                entry.put("title", record.get((Field)Tables.ARTICLES_ARTICLE.TITLE));
                entry.put("url", record.get((Field)Tables.ARTICLES_ARTICLE.URL));
                entry.put("imageUrl", record.get((Field)Tables.ARTICLES_ARTICLE.COVER));
                entry.put("pubdate", record.get((Field)Tables.ARTICLES_ARTICLE.PUBDATE));
                entry.put("channelId", record.get((Field)Tables.ARTICLES_ARTICLE.CHANNEL_ID));
                entry.put("timestamp", record.get((Field)Tables.ARTICLES_ARTICLE.TIMESTAMP));
                entry.put("content", record.get((Field)Tables.ARTICLES_ARTICLE.CONTENT));
                batch.add(entry);
                total.incrementAndGet();
                if (total.get() % 250 != 0) continue;
                System.out.println(total.get());
                System.out.println("batchok");
                batch.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

