/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.indexer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lifelines.dsl.crawler.Tables;
import com.lifelines.dsl.crawler.tables.records.ArticlesArticleRecord;
import com.lifelines.indexer.elastic.ElasticComponent;
import com.lifelines.indexer.elastic.ElasticRawDocument;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.JSONB;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jsoup.Jsoup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class Worker {
    @Autowired
    private ElasticComponent elasticComponent;
    @Value(value="${document-min-length:256}")
    private int documentMinLength;
    @Autowired
    private DSLContext dsl;
    @Autowired
    private ObjectMapper objectMapper;

    public void index(List<Map<String, Object>> entries) throws Exception {
        if (entries.isEmpty()) {
            return;
        }
        List documents = entries.stream().map(entry -> {
            String content = (String)entry.get("content");
            String cleanedContent = Jsoup.parse((String)content).text();
            UUID id = (UUID)entry.get("id");
            Instant timestamp = Instant.now();
            Instant pubdate = (Instant)entry.get("pubdate");
            return new ElasticRawDocument(id, cleanedContent, timestamp == null ? null : Long.valueOf(timestamp.toEpochMilli()), pubdate == null ? null : Long.valueOf(pubdate.toEpochMilli()));
        }).collect(Collectors.toList());
        this.elasticComponent.indexDocuments(documents);
    }

    public void process(Map<String, Object> entry) throws Exception {
        if (entry.get("channelId") == null || entry.get("siteId") == null) {
            return;
        }
        String content = (String)entry.get("content");
        String type = (String)entry.get("type");
        String title = (String)entry.get("title");
        String cleanedContent = Jsoup.parse((String)content).text();
        boolean isYoutube = "youtube".equalsIgnoreCase(type);
        boolean isTelegram = "telegram".equalsIgnoreCase(type);
        if (!isYoutube && !isTelegram && cleanedContent.length() < this.documentMinLength) {
            System.out.println("Skipped min content " + entry.get("id"));
            return;
        }
        UUID id = (UUID)entry.get("id");
        UUID channelId = (UUID)entry.get("channelId");
        UUID siteId = (UUID)entry.get("siteId");
        Instant pubdate = (Instant)entry.get("pubdate");
        Map metadataMap = (Map)entry.get("metadata");
        UUID copyOf = null;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        if (isYoutube) {
            messageDigest.update((title + cleanedContent).getBytes(StandardCharsets.UTF_8));
        } else {
            messageDigest.update(cleanedContent.getBytes(StandardCharsets.UTF_8));
        }
        UUID contentHash = UUID.nameUUIDFromBytes(messageDigest.digest());
        boolean isDuplicate = false;
        if (!isTelegram && !isYoutube) {
            Result clones = this.dsl.select((SelectField)Tables.ARTICLES_ARTICLE.ID).select(new SelectFieldOrAsterisk[]{Tables.ARTICLES_ARTICLE.SITE_ID}).select(new SelectFieldOrAsterisk[]{Tables.ARTICLES_ARTICLE.CHANNEL_ID}).from((TableLike)Tables.ARTICLES_ARTICLE).where(Tables.ARTICLES_ARTICLE.CONTENT_HASH.eq((Object)contentHash).and(Tables.ARTICLES_ARTICLE.ID.notEqual((Object)id))).limit(1).fetch();
            isDuplicate = clones.isNotEmpty();
        }
        if (isDuplicate) {
            System.out.println("Duplicate: " + channelId);
        }
        Instant nextVisit = Instant.now().plus(1L, ChronoUnit.HOURS);
        JSONB metadata = null;
        if (metadataMap != null) {
            metadata = JSONB.jsonb((String)this.objectMapper.writeValueAsString((Object)metadataMap));
        }
        Instant timestamp = Instant.now();
        ArticlesArticleRecord record = new ArticlesArticleRecord(timestamp, id, (String)entry.get("url"), pubdate, (String)entry.get("title"), null, (String)entry.get("imageUrl"), isDuplicate ? null : content, metadata, channelId, copyOf, contentHash, siteId, nextVisit, Boolean.valueOf(isDuplicate));
        this.dsl.insertInto((Table)Tables.ARTICLES_ARTICLE).set((Record)record).onDuplicateKeyUpdate().set((Record)record).execute();
        System.out.println("Indexed " + id + " " + entry.get("title"));
    }
}

