/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.indexer.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.tools.jdbc.JDBCUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

/*
 * Exception performing whole class analysis ignored.
 */
@org.springframework.context.annotation.Configuration
public class DatabaseConfiguration {
    @Value(value="${database.username}")
    private String databaseUsername;
    @Value(value="${database.password}")
    private String databasePassword;
    @Value(value="${database.host}")
    private String databaseHost;
    @Value(value="${database.name}")
    private String databaseName;

    @Bean
    @Primary
    public DataSource dataSource() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setConnectionTimeout(100000L);
        hikariConfig.setMaximumPoolSize(16);
        hikariConfig.setDataSourceClassName("org.postgresql.ds.PGSimpleDataSource");
        hikariConfig.setUsername(this.databaseUsername);
        hikariConfig.setPassword(this.databasePassword);
        hikariConfig.addDataSourceProperty("databaseName", (Object)this.databaseName);
        hikariConfig.addDataSourceProperty("serverName", (Object)this.databaseHost);
        return new HikariDataSource(hikariConfig);
    }

    @Bean
    public Configuration dslConfiguration() {
        DefaultConfiguration jooqConfiguration = new DefaultConfiguration();
        jooqConfiguration.setSQLDialect(DatabaseConfiguration.getDialect((DataSource)this.dataSource()));
        jooqConfiguration.set((ConnectionProvider)new DataSourceConnectionProvider((DataSource)new TransactionAwareDataSourceProxy(this.dataSource())));
        return jooqConfiguration;
    }

    @Bean
    @Primary
    @Qualifier(value="localDslContext")
    public DSLContext dslContext() {
        return new DefaultDSLContext(this.dslConfiguration());
    }

    private static SQLDialect getDialect(DataSource dataSource) {
        if (dataSource == null) {
            return SQLDialect.DEFAULT;
        }
        try {
            String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getURL");
            SQLDialect sqlDialect = JDBCUtils.dialect((String)url);
            if (sqlDialect != null) {
                return sqlDialect;
            }
        }
        catch (MetaDataAccessException ex) {
            ex.printStackTrace();
        }
        return SQLDialect.DEFAULT;
    }
}

