/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.indexer.config;

import com.lifelines.indexer.QueueWorker;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableRabbit
@Configuration
public class QueueConfiguration {
    @Value(value="${rabbit.host}")
    private String rabbitHost;
    @Value(value="${rabbit.port}")
    private int rabbitPort;
    @Value(value="${rabbit.username}")
    private String rabbitUsername;
    @Value(value="${rabbit.password}")
    private String rabbitPassword;
    @Value(value="${worker.enabled:false}")
    private boolean workerEnabled;
    public static final String INDEXER_QUEUE = "indexer-queue";
    public static final String INDEXER_PARALLEL_QUEUE = "indexer-parallel-queue";

    @Bean
    public QueueWorker queueWorker() {
        if (this.workerEnabled) {
            return new QueueWorker();
        }
        return null;
    }

    @Bean
    public Queue indexerQueue() {
        return new Queue(INDEXER_QUEUE, true);
    }

    @Bean
    public Queue indexerParallelQueue() {
        return new Queue(INDEXER_PARALLEL_QUEUE, true);
    }

    @Bean
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory cachingConnectionFactory = new CachingConnectionFactory(this.rabbitHost, this.rabbitPort);
        cachingConnectionFactory.setUsername(this.rabbitUsername);
        cachingConnectionFactory.setPassword(this.rabbitPassword);
        return cachingConnectionFactory;
    }

    @Bean
    public RabbitTemplate rabbitTemplate() {
        return new RabbitTemplate(this.connectionFactory());
    }

    @Bean
    public AmqpAdmin amqpAdmin() {
        return new RabbitAdmin(this.connectionFactory());
    }
}

