/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.indexer.elastic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.lifelines.indexer.elastic.ElasticRawDocument;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.http.HttpHost;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

@Component
public class ElasticComponent {
    public static final String RAW_DOCUMENTS_INDEX = "raw_documents";
    private RestHighLevelClient client;
    @Value(value="${elastic.host:localhost}")
    private String elasticHost;
    @Value(value="${elastic.port:9200}")
    private int elasticPort;
    private ObjectMapper objectMapper = new ObjectMapper();

    @PostConstruct
    public void setUp() throws IOException {
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.client = this.initialize();
    }

    public RestHighLevelClient initialize() throws IOException {
        RestHighLevelClient c = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.elasticHost, this.elasticPort, "http")}));
        if (!c.indices().exists(new GetIndexRequest(new String[]{RAW_DOCUMENTS_INDEX}), RequestOptions.DEFAULT)) {
            try (InputStream inputStream = new ClassPathResource("raw_documents_index.json").getInputStream();){
                String indexData = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.forName("UTF-8"));
                c.indices().create(new CreateIndexRequest(RAW_DOCUMENTS_INDEX).source(indexData, XContentType.JSON), RequestOptions.DEFAULT);
            }
        }
        return c;
    }

    public void indexDocuments(List<ElasticRawDocument> entries) {
        BulkRequest bulkIndexRequest = this.createBulkIndexRequest(entries);
        this.client.bulkAsync(bulkIndexRequest, RequestOptions.DEFAULT, (ActionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void indexDocument(ElasticRawDocument document) throws IOException {
        IndexRequest indexRequest = new IndexRequest(RAW_DOCUMENTS_INDEX, "_doc").id(document.getId().toString()).source(this.objectMapper.writeValueAsString((Object)document), XContentType.JSON);
        this.client.index(indexRequest, RequestOptions.DEFAULT);
    }

    public BulkRequest createBulkIndexRequest(List<ElasticRawDocument> models) {
        BulkRequest bulkIndexRequest = new BulkRequest();
        models.forEach(model -> {
            try {
                bulkIndexRequest.add(new UpdateRequest(RAW_DOCUMENTS_INDEX, "_doc", model.getId().toString()).docAsUpsert(true).doc(this.objectMapper.writeValueAsBytes(model), XContentType.JSON));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        return bulkIndexRequest;
    }

    public List<UUID> queryDocumentsIdsMulti(List<QueryBuilder> queryBuilders) throws IOException {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        queryBuilders.forEach(queryBuilder -> multiSearchRequest.add(new SearchRequest(new String[]{RAW_DOCUMENTS_INDEX}).source(new SearchSourceBuilder().fetchSource(false).trackTotalHits(false).trackScores(false).sort(SortBuilders.fieldSort((String)"timestamp").order(SortOrder.ASC)).query(queryBuilder).size(1))));
        MultiSearchResponse multiSearchResponse = this.client.msearch(multiSearchRequest, RequestOptions.DEFAULT);
        ArrayList<UUID> output = new ArrayList<UUID>();
        for (MultiSearchResponse.Item item : multiSearchResponse.getResponses()) {
            output.add(this.extractIds(item.getResponse().getHits()).stream().findFirst().orElse(null));
        }
        return output;
    }

    public List<UUID> extractIds(SearchHits searchHits) {
        return Arrays.stream(searchHits.getHits()).map(SearchHit::getId).map(UUID::fromString).collect(Collectors.toList());
    }

    public List<UUID> findCopies(List<UUID> ids, List<String> contents) throws IOException {
        ArrayList<BoolQueryBuilder> queryBuilders = new ArrayList<BoolQueryBuilder>();
        for (int i = 0; i < ids.size(); ++i) {
            BoolQueryBuilder booleanQueryBuilder = QueryBuilders.boolQuery();
            MoreLikeThisQueryBuilder queryBuilder = QueryBuilders.moreLikeThisQuery((String[])new String[]{"content"}, (String[])new String[]{contents.get(i)}, (MoreLikeThisQueryBuilder.Item[])new MoreLikeThisQueryBuilder.Item[0]).maxDocFreq(10).minTermFreq(1).minWordLength(12).minDocFreq(1).maxQueryTerms(512).minimumShouldMatch("4<85%");
            booleanQueryBuilder.must((QueryBuilder)queryBuilder);
            booleanQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)ids.get(i).toString()));
            queryBuilders.add(booleanQueryBuilder);
        }
        return this.queryDocumentsIdsMulti(queryBuilders);
    }

    public UUID findCopy(UUID id, String content) throws IOException {
        BoolQueryBuilder booleanQueryBuilder = QueryBuilders.boolQuery();
        MoreLikeThisQueryBuilder queryBuilder = QueryBuilders.moreLikeThisQuery((String[])new String[]{"content"}, (String[])new String[]{content}, (MoreLikeThisQueryBuilder.Item[])new MoreLikeThisQueryBuilder.Item[0]).minTermFreq(1).minDocFreq(1).minWordLength(4).maxQueryTerms(100).minimumShouldMatch("4<85%");
        booleanQueryBuilder.must((QueryBuilder)queryBuilder);
        booleanQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)id.toString()));
        SearchRequest searchRequest = new SearchRequest(new String[]{RAW_DOCUMENTS_INDEX}).source(new SearchSourceBuilder().fetchSource(false).sort(SortBuilders.fieldSort((String)"timestamp").order(SortOrder.ASC)).query((QueryBuilder)booleanQueryBuilder).size(1));
        SearchHits searchHits = this.client.search(searchRequest, RequestOptions.DEFAULT).getHits();
        return Arrays.stream(searchHits.getHits()).map(SearchHit::getId).map(UUID::fromString).limit(1L).findAny().orElse(null);
    }
}

