/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.tgbot.bot;

import com.lifelines.tgbot.bot.TelegramBotComponent;
import com.lifelines.tgbot.events.EventResponderComponent;
import com.lifelines.tgbot.events.SentEventLogService;
import com.lifelines.tgbot.events.dto.FeedItem;
import com.lifelines.tgbot.user.UserService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

@Component
public class ScheduledJobComponent {
    private final Logger logger = LoggerFactory.getLogger(ScheduledJobComponent.class);
    @Autowired
    private UserService userService;
    @Autowired
    private SentEventLogService sentEventLogService;
    @Autowired
    private EventResponderComponent eventResponderService;
    @Autowired
    private TelegramBotComponent telegramBotComponent;

    @Scheduled(cron="0 0 5,11,18 * * *")
    public void sendRegularFeeds() {
        List subscribedIds = this.userService.getSubscribedUsers();
        this.logger.info("Sending regular feed to {} users...", (Object)subscribedIds.size());
        List events = this.eventResponderService.getGlobalEvents(25).getItems();
        subscribedIds.forEach(userId -> {
            Set processedIds = this.sentEventLogService.getProcessedEvents(userId.longValue());
            List newEvents = events.stream().filter(event -> !processedIds.contains(event.getEventId())).collect(Collectors.toList());
            if (!newEvents.isEmpty()) {
                try {
                    this.telegramBotComponent.printFeed(newEvents, "\u0421\u0432\u0435\u0436\u0438\u0435 \u043d\u043e\u0432\u043e\u0441\u0442\u0438 \u0437\u0430 \u0441\u0435\u0433\u043e\u0434\u043d\u044f:", userId, true, true);
                    this.sentEventLogService.saveEvents(userId.longValue(), (Collection)newEvents.stream().map(FeedItem::getEventId).collect(Collectors.toList()));
                }
                catch (TelegramApiRequestException e) {
                    if (e.getErrorCode() == 403) {
                        this.userService.setSubscribed(userId.longValue(), false);
                    }
                    this.logger.error("Regular feed failure", (Throwable)e);
                }
                catch (TelegramApiException e) {
                    this.logger.error("Regular feed failure", (Throwable)e);
                }
            }
        });
    }
}

