/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.tgbot.bot;

import com.lifelines.tgbot.bot.ScheduledJobComponent;
import com.lifelines.tgbot.events.EventResponderComponent;
import com.lifelines.tgbot.events.SentEventLogService;
import com.lifelines.tgbot.events.dto.DocumentLocation;
import com.lifelines.tgbot.events.dto.FeedItem;
import com.lifelines.tgbot.events.dto.FeedResponse;
import com.lifelines.tgbot.user.UserService;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.jooq.tools.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.api.methods.AnswerInlineQuery;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputTextMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultArticle;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;

@Component
public class TelegramBotComponent
extends TelegramLongPollingBot {
    private final Logger logger = LoggerFactory.getLogger(TelegramBotComponent.class);
    private static final String BOT_TOKEN = "5393043458:AAGPZ-LOLEYY00eEXvq5euz1Nb2_x5fL81Y";
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").withZone(ZoneId.systemDefault());
    private static final int WORLD_LOCATION_ID = -3;
    private static final String WORLD_LOCATION_ID_REPLACEMENT = "world";
    @Autowired
    private UserService userService;
    @Autowired
    private EventResponderComponent eventsService;
    @Autowired
    private ScheduledJobComponent subscriptionComponent;
    @Autowired
    private SentEventLogService sentEventLogService;

    @PostConstruct
    public void init() throws TelegramApiException {
        TelegramBotsApi telegramBotsApi = new TelegramBotsApi(DefaultBotSession.class);
        telegramBotsApi.registerBot((LongPollingBot)this);
    }

    public String getBotUsername() {
        return "LifeLinesBot";
    }

    public String getBotToken() {
        return BOT_TOKEN;
    }

    public void onUpdateReceived(Update update) {
        if (update.hasMessage()) {
            User from = update.getMessage().getFrom();
            Long chatId = update.getMessage().getChatId();
            Long userId = from.getId();
            this.logger.info("Message from {}: {}", (Object)from, (Object)update.getMessage().getText());
            try {
                String message;
                boolean exists = this.userService.userExists(userId.longValue());
                if (!exists) {
                    this.userService.registerUser(userId.longValue(), from.getUserName());
                }
                if ((message = update.getMessage().getText()).contains("@")) {
                    message = message.substring(0, message.indexOf("@"));
                }
                if (message.startsWith("/loc_")) {
                    String locPart = message.replace("/loc_", "");
                    long locationId = locPart.equals(WORLD_LOCATION_ID_REPLACEMENT) ? -3L : Long.parseLong(message.replace("/loc_", ""));
                    FeedResponse events = this.eventsService.getLocationEvents(locationId, 15);
                    this.printFeed(events.getItems(), "", chatId, false, true);
                    return;
                }
                if (message.startsWith("/cat_")) {
                    long categoryId = Long.parseLong(message.replace("/cat_", ""));
                    FeedResponse events = this.eventsService.getCategoryEvents(categoryId, 15);
                    this.printFeed(events.getItems(), "", chatId, true, false);
                    return;
                }
                switch (message) {
                    case "/start": {
                        break;
                    }
                    case "/today": {
                        this.print("\u0421\u043e\u0431\u0438\u0440\u0430\u0435\u043c \u043d\u043e\u0432\u043e\u0441\u0442\u0438 \u0437\u0430 \u0441\u0435\u0433\u043e\u0434\u043d\u044f...", chatId);
                        FeedResponse events = this.eventsService.getGlobalEvents(15);
                        try {
                            this.printFeed(events.getItems(), "", chatId, true, true);
                            this.sentEventLogService.saveEvents(userId.longValue(), (Collection)events.getItems().stream().map(FeedItem::getEventId).collect(Collectors.toList()));
                        }
                        catch (TelegramApiException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case "/tomorrow": {
                        this.print("\u0421\u043e\u0431\u0438\u0440\u0430\u0435\u043c \u043d\u043e\u0432\u043e\u0441\u0442\u0438 \u043d\u0430 \u0437\u0430\u0432\u0442\u0440\u0430...", chatId);
                        FeedResponse events = this.eventsService.getTomorrowEvents(15);
                        try {
                            this.printFeed(events.getItems(), "", chatId, true, true);
                        }
                        catch (TelegramApiException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case "/yesterday": {
                        this.print("\u0421\u043e\u0431\u0438\u0440\u0430\u0435\u043c \u043d\u043e\u0432\u043e\u0441\u0442\u0438 \u0437\u0430 \u0432\u0447\u0435\u0440\u0430...", chatId);
                        FeedResponse events = this.eventsService.getYesterdayEvents(15);
                        try {
                            this.printFeed(events.getItems(), "", chatId, true, true);
                        }
                        catch (TelegramApiException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case "/subscribe": {
                        this.userService.setSubscribed(from.getId().longValue(), true);
                        this.print("\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043b\u0438\u0441\u044c \u043d\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f!", chatId);
                        break;
                    }
                    case "/unsubscribe": {
                        this.userService.setSubscribed(from.getId().longValue(), false);
                        this.print("\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0438\u0441\u0430\u043b\u0438\u0441\u044c \u043e\u0442 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439!", chatId);
                    }
                }
            }
            catch (Throwable e) {
                this.logger.error("Failure", e);
                this.print("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b :(", chatId);
            }
        } else if (update.hasInlineQuery()) {
            try {
                FeedResponse events;
                String queryId = update.getInlineQuery().getId();
                String query = update.getInlineQuery().getQuery().trim();
                FeedResponse feedResponse = events = StringUtils.isBlank((String)query) ? this.eventsService.getGlobalEvents(20) : this.eventsService.getSearch(update.getInlineQuery().getQuery(), 25);
                if (events.getItems().size() > 0) {
                    List inlineResultItems = events.getItems().stream().map(event -> {
                        String formattedDate = this.formatter.format(event.getDate());
                        InputTextMessageContent content = new InputTextMessageContent("%s - %s\n<a href=\"https://web.lifelines.name/read/%s\">%s</a>".formatted(formattedDate, event.getLocation().getName(), event.getId(), event.getTitle()), "HTML", Boolean.valueOf(false), Collections.emptyList());
                        InlineQueryResultArticle result = new InlineQueryResultArticle(event.getId().toString(), event.getTitle(), (InputMessageContent)content);
                        result.setDescription("%s - %s".formatted(formattedDate, event.getLocation().getName()));
                        result.setHideUrl(Boolean.valueOf(true));
                        result.setThumbHeight(Integer.valueOf(16));
                        result.setThumbWidth(Integer.valueOf(16));
                        result.setUrl("https://web.lifelines.name/read/" + event.getId());
                        result.setThumbUrl(event.getImageUrl());
                        return result;
                    }).collect(Collectors.toList());
                    this.execute((BotApiMethod)new AnswerInlineQuery(queryId, inlineResultItems));
                } else {
                    this.execute((BotApiMethod)new AnswerInlineQuery(queryId, Collections.emptyList()));
                }
                return;
            }
            catch (Throwable e) {
                this.logger.error("Failure", e);
            }
        }
    }

    public void printDocument(UUID documentId, String title, String url, String image, String intro, Long chatId) throws TelegramApiException {
        SendMessage message = new SendMessage();
        message.setChatId(chatId.toString());
        message.setParseMode("HTML");
        message.enableWebPagePreview();
        message.setText("<b><a href=\"https://web.lifelines.name/read/" + documentId + "\">" + title + "</a></b>\n\n" + intro);
        this.execute((BotApiMethod)message);
    }

    public void printFeed(List<FeedItem> feedItems, String title, Long chatId, boolean printLocation, boolean printCategory) throws TelegramApiException {
        Object text = feedItems.stream().map(event -> "%s - %s\n<a href=\"https://web.lifelines.name/read/%s\">\ud83d\udcf0 %s</a>\n".formatted(event.getLocation().getName(), event.getCategory().getName(), event.getId(), event.getTitle())).collect(Collectors.joining("\n"));
        if (!StringUtils.isBlank((String)title)) {
            text = title + "\n\n" + (String)text;
        }
        SendMessage message = new SendMessage();
        message.setChatId(chatId.toString());
        message.setParseMode("HTML");
        message.disableWebPagePreview();
        message.setText((String)text);
        this.execute((BotApiMethod)message);
    }

    private String printLocationId(DocumentLocation location) {
        if (location.getId() == -3) {
            return WORLD_LOCATION_ID_REPLACEMENT;
        }
        return Integer.toString(location.getId());
    }

    private void print(String text, Long chatId) {
        SendMessage message = new SendMessage();
        message.setChatId(chatId.toString());
        message.setText(text);
        try {
            this.execute((BotApiMethod)message);
        }
        catch (TelegramApiException e) {
            this.logger.error("Failure", (Throwable)e);
        }
    }
}

