/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.tgbot.config;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.tools.jdbc.JDBCUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

/*
 * Exception performing whole class analysis ignored.
 */
@org.springframework.context.annotation.Configuration
public class DatabaseConfiguration {
    @Bean
    @ConfigurationProperties(value="database")
    public DataSourceProperties dataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @ConfigurationProperties(value="database.hikari")
    public DataSource dataSource() {
        return this.dataSourceProperties().initializeDataSourceBuilder().type(HikariDataSource.class).build();
    }

    @Bean
    @Autowired
    public DataSourceTransactionManager quotesTM(DataSource datasource) {
        return new DataSourceTransactionManager(datasource);
    }

    @Bean
    public Configuration dslConfiguration() {
        DefaultConfiguration jooqConfiguration = new DefaultConfiguration();
        jooqConfiguration.setSQLDialect(DatabaseConfiguration.getDialect((DataSource)this.dataSource()));
        jooqConfiguration.set((ConnectionProvider)new DataSourceConnectionProvider((DataSource)new TransactionAwareDataSourceProxy(this.dataSource())));
        return jooqConfiguration;
    }

    @Bean
    public DSLContext dslContext() {
        return new DefaultDSLContext(this.dslConfiguration());
    }

    private static SQLDialect getDialect(DataSource dataSource) {
        if (dataSource == null) {
            return SQLDialect.DEFAULT;
        }
        try {
            String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getURL");
            return JDBCUtils.dialect((String)url);
        }
        catch (MetaDataAccessException ex) {
            ex.printStackTrace();
            return SQLDialect.DEFAULT;
        }
    }
}

