/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.tgbot.events;

import com.lifelines.tgbot.events.dto.FeedResponse;
import java.time.LocalDate;
import java.time.ZoneId;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class EventResponderComponent {
    private static final String BOT_HEADER = "TGBOT";
    private static final String SERVICE_BASE = "http://point.lifelines.name";

    public FeedResponse getSearch(String query, int totalEvents) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.exchange("http://point.lifelines.name/api/v4/search?page=0&pageSize={total}&query={query}", HttpMethod.GET, this.createHttpEntity(), FeedResponse.class, new Object[]{totalEvents, query});
        return (FeedResponse)response.getBody();
    }

    public FeedResponse getGlobalEvents(int totalEvents) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.exchange("http://point.lifelines.name/api/v4/feed/global?page=0&pageSize={total}&minSize=2.5", HttpMethod.GET, this.createHttpEntity(), FeedResponse.class, new Object[]{totalEvents});
        return (FeedResponse)response.getBody();
    }

    public FeedResponse getTomorrowEvents(int totalEvents) {
        RestTemplate restTemplate = new RestTemplate();
        LocalDate date = LocalDate.now(ZoneId.of("Europe/Moscow")).plusDays(1L);
        ResponseEntity response = restTemplate.exchange("http://point.lifelines.name/api/v4/feed/global?page=0&pageSize={total}&date={date}", HttpMethod.GET, this.createHttpEntity(), FeedResponse.class, new Object[]{totalEvents, date});
        return (FeedResponse)response.getBody();
    }

    public FeedResponse getYesterdayEvents(int totalEvents) {
        RestTemplate restTemplate = new RestTemplate();
        LocalDate date = LocalDate.now(ZoneId.of("Europe/Moscow")).minusDays(1L);
        ResponseEntity response = restTemplate.exchange("http://point.lifelines.name/api/v4/feed/global?page=0&pageSize={total}&date={date}", HttpMethod.GET, this.createHttpEntity(), FeedResponse.class, new Object[]{totalEvents, date});
        return (FeedResponse)response.getBody();
    }

    public FeedResponse getLocationEvents(long locationId, int totalEvents) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.exchange("http://point.lifelines.name/api/v4/search?page=0&pageSize={total}&location={locationId}", HttpMethod.GET, this.createHttpEntity(), FeedResponse.class, new Object[]{totalEvents, locationId});
        return (FeedResponse)response.getBody();
    }

    public FeedResponse getCategoryEvents(long categoryId, int totalEvents) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.exchange("http://point.lifelines.name/api/v4/search?page=0&pageSize={total}&category={categoryId}", HttpMethod.GET, this.createHttpEntity(), FeedResponse.class, new Object[]{totalEvents, categoryId});
        return (FeedResponse)response.getBody();
    }

    private HttpEntity<?> createHttpEntity() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("DEV_IX", BOT_HEADER);
        return new HttpEntity((MultiValueMap)headers);
    }
}

