/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.tgbot.events;

import com.lifelines.tgbot.jooq.Tables;
import com.lifelines.tgbot.jooq.tables.records.SentEventLogRecord;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SentEventLogService {
    @Autowired
    private DSLContext dsl;

    @Transactional
    public Set<UUID> getUnprocessedEvents(long userId, Collection<UUID> ids) {
        Set existing = this.dsl.select((SelectField)Tables.SENT_EVENT_LOG.EVENT_ID).from((TableLike)Tables.SENT_EVENT_LOG).where(Tables.SENT_EVENT_LOG.TG_USER_ID.eq((Object)userId)).and(Tables.SENT_EVENT_LOG.EVENT_ID.in(ids)).fetchSet((Field)Tables.SENT_EVENT_LOG.EVENT_ID);
        return ids.stream().filter(id -> !existing.contains(id)).collect(Collectors.toSet());
    }

    @Transactional
    public Set<UUID> getProcessedEvents(long userId) {
        return this.dsl.select((SelectField)Tables.SENT_EVENT_LOG.EVENT_ID).from((TableLike)Tables.SENT_EVENT_LOG).where(Tables.SENT_EVENT_LOG.TG_USER_ID.eq((Object)userId)).fetchSet((Field)Tables.SENT_EVENT_LOG.EVENT_ID);
    }

    @Transactional
    public void saveEvents(long userId, Collection<UUID> ids) {
        this.dsl.insertInto((Table)Tables.SENT_EVENT_LOG, (Field)Tables.SENT_EVENT_LOG.TG_USER_ID, (Field)Tables.SENT_EVENT_LOG.EVENT_ID, (Field)Tables.SENT_EVENT_LOG.SENT_AT).valuesOfRecords((Collection)ids.stream().map(id -> new SentEventLogRecord(Long.valueOf(userId), id, Instant.now())).collect(Collectors.toList())).onDuplicateKeyIgnore().execute();
    }
}

