/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.tgbot.rabbit;

import com.lifelines.tgbot.bot.TelegramBotComponent;
import com.lifelines.tgbot.events.SentEventLogService;
import com.lifelines.tgbot.user.UserService;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

@Component
public class PushService {
    @Autowired
    private UserService userService;
    @Autowired
    private SentEventLogService sentEventLogService;
    @Autowired
    private TelegramBotComponent telegramBotComponent;

    @RabbitListener(queues={"push-news-queue"})
    public void listen(Map<String, Object> entry) {
        UUID id = (UUID)entry.get("documentId");
        UUID eventID = (UUID)entry.get("eventId");
        Double eventWeight = (Double)entry.get("eventWeight");
        Instant publishedAt = (Instant)entry.get("publishedAt");
        if (publishedAt.plus(1L, ChronoUnit.HOURS).isBefore(Instant.now())) {
            return;
        }
        if (eventWeight == null || eventWeight <= 30.0) {
            return;
        }
        System.out.println(entry.get("title") + " " + eventWeight + " eventId: " + eventID + "  documentId: " + id);
        System.out.println("");
        List subscribedIds = this.userService.getSubscribedUsers();
        subscribedIds.forEach(userId -> {
            Set processedIds = this.sentEventLogService.getUnprocessedEvents(userId.longValue(), Collections.singleton(eventID));
            if (!processedIds.isEmpty()) {
                try {
                    this.telegramBotComponent.printDocument(id, (String)entry.get("title"), (String)entry.get("url"), (String)entry.get("image"), (String)entry.get("intro"), userId);
                    this.sentEventLogService.saveEvents(userId.longValue(), Collections.singleton(eventID));
                }
                catch (TelegramApiRequestException e) {
                    if (e.getErrorCode() == 403) {
                        this.userService.setSubscribed(userId.longValue(), false);
                    }
                }
                catch (TelegramApiException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

