/*
 * Decompiled with CFR 0.152.
 */
package com.lifelines.tgbot.rabbit;

import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableRabbit
@Configuration
public class RabbitConfiguration {
    @Value(value="${rabbit.host}")
    private String rabbitHost;
    @Value(value="${rabbit.port}")
    private int rabbitPort;
    @Value(value="${rabbit.username}")
    private String rabbitUsername;
    @Value(value="${rabbit.password}")
    private String rabbitPassword;

    @Bean
    @Qualifier(value="pushNewsQueue")
    public Queue pushNewsQueue() {
        return new Queue("push-news-queue", false, true, true);
    }

    @Bean
    public TopicExchange exchange() {
        return new TopicExchange("push-queue-exchange");
    }

    @Bean
    public Binding binding(@Qualifier(value="pushNewsQueue") Queue queue, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with("push.news");
    }

    @Bean
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory cachingConnectionFactory = new CachingConnectionFactory(this.rabbitHost, this.rabbitPort);
        cachingConnectionFactory.setUsername(this.rabbitUsername);
        cachingConnectionFactory.setPassword(this.rabbitPassword);
        return cachingConnectionFactory;
    }

    @Bean
    public RabbitTemplate rabbitTemplate() {
        return new RabbitTemplate(this.connectionFactory());
    }

    @Bean
    public AmqpAdmin amqpAdmin() {
        return new RabbitAdmin(this.connectionFactory());
    }
}

